/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.RedstoneMode;
import appeng.api.config.Setting;
import appeng.api.inventories.InternalInventory;
import appeng.api.parts.IPartItem;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.core.definitions.AEItems;
import appeng.parts.BasicStatePart;
import appeng.util.ConfigManager;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public abstract class UpgradeablePart
extends BasicStatePart
implements IConfigurableObject,
IUpgradeableObject {
    private final IConfigManager config;
    private final IUpgradeInventory upgrades;

    public UpgradeablePart(IPartItem<?> partItem) {
        super(partItem);
        this.upgrades = UpgradeInventories.forMachine((ItemLike)partItem.m_5456_(), this.getUpgradeSlots(), this::onUpgradesChanged);
        this.config = new ConfigManager((manager, setting) -> {
            this.onSettingChanged(manager, setting);
            this.getHost().markForSave();
        });
    }

    private void onUpgradesChanged() {
        this.getHost().markForSave();
        this.upgradesChanged();
    }

    protected int getUpgradeSlots() {
        return 4;
    }

    public void upgradesChanged() {
    }

    protected boolean isSleeping() {
        if (this.upgrades.isInstalled(AEItems.REDSTONE_CARD)) {
            return switch (this.getRSMode()) {
                default -> throw new IncompatibleClassChangeError();
                case RedstoneMode.IGNORE -> false;
                case RedstoneMode.HIGH_SIGNAL -> {
                    if (!this.getHost().hasRedstone()) {
                        yield true;
                    }
                    yield false;
                }
                case RedstoneMode.LOW_SIGNAL -> this.getHost().hasRedstone();
                case RedstoneMode.SIGNAL_PULSE -> true;
            };
        }
        return false;
    }

    @Override
    public boolean canConnectRedstone() {
        return this.upgrades.getMaxInstalled(AEItems.REDSTONE_CARD) > 0;
    }

    @Override
    public void readFromNBT(CompoundTag extra) {
        super.readFromNBT(extra);
        this.config.readFromNBT(extra);
        this.upgrades.readFromNBT(extra, "upgrades");
    }

    @Override
    public void writeToNBT(CompoundTag extra) {
        super.writeToNBT(extra);
        this.config.writeToNBT(extra);
        this.upgrades.writeToNBT(extra, "upgrades");
    }

    @Override
    public void addAdditionalDrops(List<ItemStack> drops, boolean wrenched) {
        for (ItemStack is : this.upgrades) {
            if (is.m_41619_()) continue;
            drops.add(is);
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.config;
    }

    @Override
    @Nullable
    public InternalInventory getSubInventory(ResourceLocation id) {
        if (id.equals((Object)UPGRADES)) {
            return this.upgrades;
        }
        return super.getSubInventory(id);
    }

    @Override
    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    public RedstoneMode getRSMode() {
        return null;
    }

    protected void onSettingChanged(IConfigManager manager, Setting<?> setting) {
    }
}

